***********************************************************
* ECHO.SRC - prompt with a command line, echo input       *
*            line to output, repeat until 'q' is entered  *
***********************************************************
CR       EQU      $0D
LF       EQU      $0A
         EXTERN   OUTSTR,INLINE,OUTLINE
         EXTERN   BUFFER,TOUPPR
***********************************************************
* Put in a code segment called 'EPROM'                    *
***********************************************************
         RSEG     EPROM
LOOP     MOVEA.L  #PROMPT,A1  ;A1 points to prompt string
         JSR      >OUTSTR     ;output prompt string
         JSR      >INLINE     ;get input from keyboard
         MOVEA.L  #BUFFER,A1  ;check for quit character
         MOVE.B   (A1)+,D0    ;put 1st char in D0
         JSR      >TOUPPR     ;convert to uppercase
         CMP.B    #'Q',D0     ;Q?
         BEQ.S    EXIT        ;yes: exit
         JSR      >OUTLINE    ;no:  output line
         BRA.S    LOOP
EXIT     TRAP     #14         ;return to MON68K

PROMPT   DC.B     CR,LF,'Enter a command: ',0
         END      LOOP
